"use strict";

(function( $ ) {
	var itsecMalware = {
		init: function() {
			this.bindEvents();
		},

		bindEvents: function() {
			$(document).on('click', '.itsec-malware-scan-results .itsec-malware-scan-toggle-details', this.toggleDetails);
		},

		toggleDetails: function( event ) {
			event.preventDefault();

			var $container = $(this).parents('.itsec-malware-scan-results-section');
			var $details = $container.find('.itsec-malware-scan-details');

			if ( $details.is(':visible') ) {
				$(this).html('Show Details');
				$details.hide();
			} else {
				$(this).html('Hide Details');
				$details.show();
			}
		}
	};

	$(document).ready(function() {
		itsecMalware.init();
	});
})( jQuery );
