<?php

namespace Tests\Validators;

use GUMP;
use Exception;
use Tests\BaseTestCase;

/**
 * Class ValidJsonStringValidatorTest
 *
 * @package Tests
 */
class ValidJsonStringValidatorTest extends BaseTestCase
{
    private const RULE = 'valid_json_string';

    /**
     * @dataProvider successProvider
     */
    public function testSuccess($input)
    {
        $this->assertTrue($this->validate(self::RULE, $input));
    }

    public function successProvider()
    {
        return [
            ['{}'],
            ['{"testing": true}'],
        ];
    }

    /**
     * @dataProvider errorProvider
     */
    public function testError($input)
    {
        $this->assertNotTrue($this->validate(self::RULE, $input));
    }

    public function errorProvider()
    {
        return [
            ['{}}'],
            ['{test:true}'],
            ['{"test":text}'],
        ];
    }
}